<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 31.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/cron.php';
requireIncluded(basename(__FILE__));
?>
<!DOCTYPE html>
<html lang="de">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<meta name="author" content="Cedric Prietz">
	<title>SONICCG - <?php echo $pageName; ?></title>
	<script src="/assets/js/color-modes.js"></script>

	<link rel="preconnect" href="https://fonts.googleapis.com/">
	<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&amp;display=swap"
		rel="stylesheet">

	<link rel="stylesheet" href="/assets/vendors/core/core.css">
	<link rel="stylesheet" href="/assets/vendors/select2/select2.min.css">
	<link rel="stylesheet" href="/assets/vendors/jquery-tags-input/jquery.tagsinput.min.css">
	<link rel="stylesheet" href="/assets/vendors/dropify/dist/dropify.min.css">
	<link rel="stylesheet" href="/assets/vendors/pickr/themes/classic.min.css">
	<link rel="stylesheet" href="/assets/vendors/font-awesome/css/font-awesome.min.css">
	<link rel="stylesheet" href="/assets/vendors/flatpickr/flatpickr.min.css">
	<link rel="stylesheet" href="/assets/vendors/datatables.net-bs5/dataTables.bootstrap5.css">
	<link rel="stylesheet" href="/assets/vendors/sweetalert2/sweetalert2.min.css">
	<link rel="stylesheet" href="/assets/vendors/easymde/easymde.min.css">
	<link rel="stylesheet" href="/assets/fonts/feather-font/css/iconfont.css">
	<link rel="stylesheet" href="/assets/vendors/mdi/css/materialdesignicons.min.css">
	<link rel="stylesheet" href="/assets/vendors/leaflet/leaflet.css">
	<link rel="stylesheet" href="/assets/css/style.css">

	<link rel="shortcut icon" href="/assets/images/favicon.ico" />

	<noscript>
		<meta http-equiv="refresh" content="0; URL=/javascript-required.php">
	</noscript>
</head>

<body class="navbar-dark">
	<div class="main-wrapper">

		<div class="horizontal-menu">
			<nav class="navbar top-navbar">
				<div class="container">
					<div class="navbar-content">

						<a href="#" class="navbar-brand d-lg-flex">
							SONIC<span>CG</span>
						</a>

						<ul class="navbar-nav">

							<li class="nav-item">
								<a class="nav-link" href="#" id="fullscreen-toggle" data-bs-toggle="tooltip"
									data-bs-html="true" data-bs-placement="bottom" title="Vollbildmodus</br><b>F11</b>">
									<span class="mdi mdi-fullscreen"></span>
								</a>
							</li>

							<li class="nav-item">
								<a class="nav-link" href="/assets/documents/Nutzerhandbuch.pdf" target="_blank"
									id="fullscreen-toggle" data-bs-toggle="tooltip" data-bs-html="true"
									data-bs-placement="bottom" title="Handbuch">
									<span class="mdi mdi-book-open-variant-outline"></span>
								</a>
							</li>

							<li class="theme-switcher-wrapper nav-item">
								<input type="checkbox" value="" id="theme-switcher">
								<label for="theme-switcher">
									<div class="box">
										<div class="ball"></div>
										<div class="icons">
											<i class="feather icon-sun"></i>
											<i class="feather icon-moon"></i>
										</div>
									</div>
								</label>
							</li>


							<li class="nav-item dropdown">
								<a class="nav-link dropdown-toggle" href="#" id="profileDropdown" role="button"
									data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<img class="w-30px h-30px ms-1 rounded-circle" src="/assets/images/profile.jpg"
										alt="profile">
								</a>
								<div class="dropdown-menu p-0" aria-labelledby="profileDropdown">
									<div class="d-flex flex-column align-items-center border-bottom px-5 py-3">
										<div class="mb-3">
											<img class="w-80px h-80px rounded-circle" src="/assets/images/profile.jpg"
												alt="">
										</div>
										<div class="text-center">
											<p class="fs-16px fw-bolder"><?php echo $_SESSION['DisplayName']; ?></p>
											<p class="fs-12px text-secondary"><?php echo $_SESSION['Role']; ?></p>
										</div>
									</div>
									<ul class="list-unstyled p-1">
										<?php if ($_SESSION['Type'] == 'local') { ?>
											<a href="/profile" class="text-body ms-0">
												<li class="dropdown-item py-2">
													<i class="me-2 icon-md mdi mdi-account-cog"></i>
													<span>Mein Konto</span>
												</li>
											</a>
										<?php } ?>
										<a href="/logout" class="text-body ms-0">
											<li class="dropdown-item py-2">
												<i class="me-2 icon-md" data-feather="log-out"></i>
												<span>Abmelden</span>
											</li>
										</a>
									</ul>
								</div>
							</li>
						</ul>

						<!-- navbar toggler for small devices -->
						<div data-toggle="horizontal-menu-toggle"
							class="navbar-toggler navbar-toggler-right d-lg-none align-self-center">
							<span></span>
							<span></span>
							<span></span>
							<span></span>
						</div>

					</div>
				</div>
			</nav>
			<nav class="bottom-navbar">
				<div class="container">
					<ul class="nav page-navigation">

						<li class="nav-item">
							<a class="nav-link" href="/dashboard">
								<i class="link-icon mdi mdi-view-dashboard"></i>
								<span class="menu-title">Dashboard</span>
							</a>
						</li>

						<li class="nav-item">
							<a class="nav-link" href="/map">
								<i class="link-icon mdi mdi-map"></i>
								<span class="menu-title">Karte</span>
							</a>
						</li>

						<?php showIfRole(['Bediener', 'Bearbeiter', 'Administrator'], '
							<li class="nav-item">
								<a class="nav-link" href="/terminal/login">
									<i class="link-icon mdi mdi-checkbook-arrow-right"></i>
									<span class="menu-title">Terminal</span>
								</a>
							</li>
					 	'); ?>

						<?php showIfRole(['Bearbeiter', 'Auswerter', 'Administrator'], '
							<li class="nav-item">
								<a class="nav-link" href="/reports/reportboard">
									<i class="link-icon mdi mdi-chart-box-outline"></i>
									<span class="menu-title">Berichte</span>
								</a>
							</li>
					 	'); ?>

						<?php showIfRole(['Bediener'], '
							<li class="nav-item">
								<a class="nav-link" href="/identities/authorized-identities">
									<i class="link-icon mdi mdi-account-group"></i>
									<span class="menu-title">Identitäten</span>
								</a>
							</li>
					 	'); ?>

						<?php showIfRole(['Bearbeiter', 'Administrator'], '
							<li class="nav-item">
								<a class="nav-link" href="/identities/identitiesboard">
									<i class="link-icon mdi mdi-sitemap"></i>
									<span class="menu-title">Identitäten</span>
									<i class="link-arrow"></i>
								</a>
								<div class="submenu">
									<ul class="submenu-item">
										<li class="nav-item"><a class="nav-link" href="/identities/positions">Dienstposten</a></li>
										<li class="nav-item"><a class="nav-link" href="/identities/identities">Identitäten</a></li>
									</ul>
								</div>
							</li>
					 	'); ?>

						<?php showIfRole(['Auditor', 'Administrator'], '
							<li class="nav-item">
								<a href="#" class="nav-link">
									<i class="link-icon mdi mdi-eye-check-outline"></i>
									<span class="menu-title">Auditing</span>
									<i class="link-arrow"></i>
								</a>
								<div class="submenu">
									<ul class="submenu-item">
										<li class="nav-item"><a class="nav-link" href="/auditing/permissions">Berechtigungen</a></li>
										<li class="nav-item"><a class="nav-link" href="/auditing/protocols">Protokolle</a></li>
										<li class="nav-item"><a class="nav-link" href="/auditing/bookinghistory">Buchungshistorie</a></li>
									</ul>
								</div>
							</li>
					 	'); ?>

						<?php showIfRole(['Administrator'], '
							<li class="nav-item">
								<a href="#" class="nav-link">
									<i class="link-icon mdi mdi-cog"></i>
									<span class="menu-title">Administration</span>
									<i class="link-arrow"></i>
								</a>
								<div class="submenu">
									<ul class="submenu-item">
										<li class="nav-item"><a class="nav-link" href="/administration/accounts">Benutzerkonten</a></li>
										<li class="nav-item"><a class="nav-link" href="/administration/zones">Zonen</a></li>
										<li class="nav-item"><a class="nav-link" href="/administration/shelters">Schutzbauten</a></li>
										<li class="nav-item"><a class="nav-link" href="/administration/backup">Backup</a></li>
									</ul>
								</div>
							</li>
					 	'); ?>



					</ul>
				</div>
			</nav>
		</div>

		<div class="page-wrapper">

			<div class="page-content" id="page-content">